/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.screen.InventoryButtonReturnConfirmScreen;
import net.blay09.mods.waystones.client.gui.widget.WaystoneInventoryButton;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.InventoryButtonMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="waystones", value={Dist.CLIENT})
public class InventoryButtonGuiHandler {
    private static WaystoneInventoryButton buttonWarp;

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Supplier<Integer> xPosition;
        if (!(event.getGui() instanceof InventoryScreen) && !(event.getGui() instanceof CreativeScreen)) {
            return;
        }
        if (event.getGui() != Minecraft.func_71410_x().field_71462_r) {
            return;
        }
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getInventoryButtonMode();
        if (!inventoryButtonMode.isEnabled()) {
            return;
        }
        Supplier<Integer> supplier = event.getGui() instanceof CreativeScreen ? () -> WaystonesConfig.CLIENT.creativeWarpButtonX.get() : (xPosition = () -> WaystonesConfig.CLIENT.teleportButtonX.get());
        Supplier<Integer> yPosition = event.getGui() instanceof CreativeScreen ? () -> WaystonesConfig.CLIENT.creativeWarpButtonY.get() : () -> WaystonesConfig.CLIENT.teleportButtonY.get();
        buttonWarp = new WaystoneInventoryButton((ContainerScreen)event.getGui(), button -> {
            Minecraft mc = event.getGui().getMinecraft();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player.field_71075_bZ.field_75098_d) {
                PlayerWaystoneManager.setInventoryButtonCooldownUntil((PlayerEntity)player, 0L);
            }
            if (PlayerWaystoneManager.canUseInventoryButton((PlayerEntity)player)) {
                if (inventoryButtonMode.hasNamedTarget()) {
                    mc.func_147108_a((Screen)new InventoryButtonReturnConfirmScreen(inventoryButtonMode.getNamedTarget()));
                } else if (inventoryButtonMode.isReturnToNearest()) {
                    if (PlayerWaystoneManager.getNearestWaystone((PlayerEntity)player) != null) {
                        mc.func_147108_a((Screen)new InventoryButtonReturnConfirmScreen());
                    }
                } else if (inventoryButtonMode.isReturnToAny()) {
                    NetworkHandler.channel.sendToServer((Object)new InventoryButtonMessage());
                }
            } else {
                mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.5f));
            }
        }, () -> {
            if (event.getGui() instanceof CreativeScreen) {
                CreativeScreen gui = (CreativeScreen)event.getGui();
                return gui.func_147056_g() == ItemGroup.field_78036_m.func_78021_a();
            }
            return true;
        }, xPosition, yPosition);
        event.addWidget((Widget)buttonWarp);
    }

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if ((event.getGui() instanceof InventoryScreen || event.getGui() instanceof CreativeScreen) && buttonWarp != null && buttonWarp.func_230449_g_()) {
            InventoryButtonMode inventoryButtonMode = WaystonesConfig.getInventoryButtonMode();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            long timeLeft = PlayerWaystoneManager.getInventoryButtonCooldownLeft((PlayerEntity)player);
            IWaystone waystone = PlayerWaystoneManager.getInventoryButtonWaystone((PlayerEntity)player);
            int xpLevelCost = waystone != null ? PlayerWaystoneManager.getExperienceLevelCost((Entity)player, waystone, WarpMode.INVENTORY_BUTTON, (IWaystone)null) : 0;
            int secondsLeft = (int)(timeLeft / 20L);
            if (inventoryButtonMode.hasNamedTarget()) {
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.YELLOW, "gui.waystones.inventory.return_to_waystone", new Object[0]));
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.GRAY, "tooltip.waystones.bound_to", TextFormatting.DARK_AQUA + inventoryButtonMode.getNamedTarget()));
                if (secondsLeft > 0) {
                    tooltip.add(new StringTextComponent(""));
                }
            } else if (inventoryButtonMode.isReturnToNearest()) {
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.YELLOW, "gui.waystones.inventory.return_to_nearest_waystone", new Object[0]));
                IWaystone nearestWaystone = PlayerWaystoneManager.getNearestWaystone((PlayerEntity)player);
                if (nearestWaystone != null) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.GRAY, "tooltip.waystones.bound_to", TextFormatting.DARK_AQUA + nearestWaystone.getName()));
                } else {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.RED, "gui.waystones.inventory.no_waystones_activated", new Object[0]));
                }
                if (secondsLeft > 0) {
                    tooltip.add(new StringTextComponent(""));
                }
            } else if (inventoryButtonMode.isReturnToAny()) {
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.YELLOW, "gui.waystones.inventory.return_to_waystone", new Object[0]));
                if (PlayerWaystoneManager.getWaystones((PlayerEntity)player).isEmpty()) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.RED, "gui.waystones.inventory.no_waystones_activated", new Object[0]));
                }
            }
            if (xpLevelCost > 0 && player.field_71068_ca < xpLevelCost) {
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.RED, "tooltip.waystones.not_enough_xp", xpLevelCost));
            }
            if (secondsLeft > 0) {
                tooltip.add(InventoryButtonGuiHandler.formatTranslation(TextFormatting.GOLD, "tooltip.waystones.cooldown_left", secondsLeft));
            }
            event.getGui().func_243308_b(event.getMatrixStack(), tooltip, event.getMouseX(), event.getMouseY());
        }
    }

    private static ITextComponent formatTranslation(TextFormatting formatting, String key, Object ... args) {
        TranslationTextComponent result = new TranslationTextComponent(key, args);
        result.func_240699_a_(formatting);
        return result;
    }
}

